# **디자인 패턴**

## 작성자
[![tdm1223](https://avatars1.githubusercontent.com/u/21440957?s=100&v=4)](https://github.com/tdm1223)
[![rlatjdwo555](https://avatars0.githubusercontent.com/u/28692938?s=100&v=4)](https://github.com/rlatjdwo555)
[![Stupid07](https://avatars1.githubusercontent.com/u/35564566?s=100&v=4)](https://github.com/Stupid07)

## 디자인 패턴
### 생성 패턴
- 객체 생성에 관련된 패턴
- 객체의 생성을 캡슐화해 특정 객체가 생성되거나 변경되어도 프로그램 구조에 영향을 크게 받지 않도록 유연성을 제공한다.

#### 종류
- **Abstract Factory**
    - 구체적인 클래스에 의존하지 않고 서로 연관되거나 의존적인 객체들의 조합을 만드는 인터페이스를 제공하는 패턴
- **Factory**
    - 객체 생성 처리를 서브 클래스로 분리해 처리하도록 캡슐화하는 패턴
- **Singleton**
    - 전역 변수를 사용하지 않고 객체를 하나만 생성하도록 하며, 생성된 객체를 어디에서든지 참조할 수 있도록 하는 패턴
       
### 구조 패턴
- 클래스나 객체를 조합해 더 큰 구조를 만드는 패턴
- 서로 다른 인터페이스를 지닌 2개의 객체를 묶어 단일 인터페이스를 제공하거나 객체들을 서로 묶어 새로운 기능을 제공하는 패턴

#### 종류
- **Adapter**
    - 직접적으로 호출하지 않고 중간에 어댑터를 통해 호출함으로서 호환성이 없더라도 함께 동작할 수 있고 유지보수를 쉽게 하기 위한 패턴
- **Composite**
    - 여러 개의 객체들로 구성된 객체와 단일 객체를 클라이언트에서 구별 없이 다루게 해주는 패턴
- **Decorator**
    - 객체의 결합을 통해 기능을 동적으로 유연하게 확장할 수 있게 해주는 패턴
- **Facade**
    - 복잡한 호출과정을 대신 처리해주는 wrapper 객체를 따로 만들어서 쉽게 사용할 수 있게 해주는 패턴 
- **Proxy**
    - 대리자 객체를 통해 결과를 변경하지 않고 흐름 제어를 할 수 있도록 하는 패턴 
### 행위 패턴
- 객체나 클래스 사이의 알고리즘이나 책임 분배에 관련된 패턴
- 객체가 혼자 수행할 수 없는 작업을 여러 개의 객체로 분배하면서 객체 사이의 결합도를 최소화하는 것에 중점을 두는 패턴

#### 종류
- **Observer**
    - 한 객체의 상태 변화에 따라 다른 객체의 상태도 연동되도록 일대다 객체 의존 관계를 구성하는 패턴
- **State**
    - 객체의 상태에 따라 객체의 행위 내용을 변경해주는 패턴
- **Strategy**
    - 행위를 클래스로 캡슐화해 동적으로 행위를 자유롭게 바꿀 수 있게 해주는 패턴
- **Template Method**
    - 어떤 작업을 처리하는 일부분을 서브 클래스로 캡슐화해 전체 일을 수행하는 구조는 바꾸지 않으면서 특정 단계에서 수행하는 내역을 바꾸는 패턴
- **Command**
    - 실행될 기능을 캡슐화함으로써 주어진 여러 기능을 실행할 수 있는 재사용성이 높은 클래스를 설계하는 패턴

## Link
[참고블로그](https://gmlwjd9405.github.io/2018/07/06/design-pattern.html)

